##########################################################
#                 Author C. Jarne                        #
#            bynary_ff_recurren_to_show.py  (ver 2.0)    #                       
#  Based on a Keras-Cog task from Alexander Atanasov     #
#  A SR flip-flop task (high to low edge triggered)      #                
#                                                        #
# MIT LICENCE                                            #
##########################################################

import numpy as np
import matplotlib.pyplot as plt
import time
import math
import keras.backend as K

#From Keras
from keras.models import Sequential
from keras.layers.core import Dense
from keras.callbacks import ModelCheckpoint
from keras.layers.recurrent import SimpleRNN
from keras.layers import TimeDistributed, Dense, Activation, Dropout
from keras.utils import plot_model
from keras import metrics, optimizers, regularizers, initializers
from keras.constraints import non_neg

# taking dataset from function
from generate_data_set_ran import *

start_time = time.time()

#Parameters

sample_size      = 20050
epochs           = 20
N_rec            = 50#100
p_connect        = 1 #0.9
g                =2.4


#Generate Training Data
x_train,y_train, seq_dur,mask  = generate_data_set(sample_size,20) 

# Init my parameters

def my_init_rec(shape, name=None):
    value = np.random.random(shape)
    mu=0
    sigma=0.01#/(N_rec*N_rec)#0.05
    value= g*np.random.normal(mu, sigma, shape)
    return K.variable(value, name=name)

#Network model construction

model = Sequential()
model.add(SimpleRNN(units= N_rec,return_sequences=True, input_shape=(None, 2), kernel_initializer='glorot_uniform', recurrent_initializer='orthogonal',use_bias=True,bias_initializer='zeros',recurrent_dropout=1-p_connect))
model.add(Dense(units=1, activation="linear", input_dim=N_rec))

model.save('weights_ff/initial.hdf5')

# Model Compiling:

ADAM= optimizers.Adam(lr=0.0001, beta_1=0.9, beta_2=0.999,epsilon=1e-08, decay=0.0001)
model.compile(loss = 'mse', optimizer=ADAM, sample_weight_mode="temporal")

# Saving weigths post training
filepath       = 'weights_ff/ff_weights-{epoch:02d}.hdf5'
checkpoint = ModelCheckpoint(filepath)

history        = model.fit(x_train[50:sample_size,:,:], y_train[50:sample_size,:,:], epochs=epochs, batch_size=64, callbacks = [checkpoint], sample_weight  =mask[50:sample_size,:])


# Model Testing: 
x_pred = x_train[0:50,:,:]
y_pred = model.predict(x_pred)

print("x_train shape:\n",x_train.shape)
print("x_pred shape\n",x_pred.shape)
print("y_train shape\n",y_train.shape)

fig     = plt.figure(figsize=(6,8))
fig.suptitle("\"Flip-Flop\" Data Set Trainined Output \n (amplitude in arb. units time in mSec)",fontsize = 20)
for ii in np.arange(10):
    plt.subplot(5, 2, ii + 1)    
    plt.plot(x_train[ii, :, 0],color='g',label="input Set")
    plt.plot(x_train[ii, :, 1],color='b',label="input Reset")
    plt.plot(y_train[ii, :, 0],color='k',linewidth=3,label="Desierd output")
    plt.plot(y_pred[ii, :, 0], color='r',label="Predicted Output")
    plt.ylim([-2.5, 2.5])
    plt.legend(fontsize= 5,loc=3)
    plt.xticks(fontsize=8)
    plt.yticks(fontsize=8)
    figname = "plots_ff/data_set_flip_flop_sample_trained.png" 
    plt.savefig(figname,dpi=200)
#plt.close()
#plt.show()

print(model.summary())
plot_model(model, to_file='plots_ff/model.png')

print "history keys",(history.history.keys())

print("--- %s to train the network seconds ---" % (time.time() - start_time))

# "Loss Plot"

fig     = plt.figure(figsize=(8,6)) 
plt.grid(True)
plt.plot(history.history['loss'])
plt.title('Model loss during training')
plt.ylabel('loss')
plt.xlabel('epoch')
plt.legend(['train', 'validation'], loc='upper left')
figname = "plots_ff/model_loss.png" 
plt.savefig(figname,dpi=200)

plt.show()


